<?php

namespace App\Http\Controllers;

use App\Models\Calculation;
use App\Models\ProductType;
use App\Models\Formula;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $totalCalculations = Calculation::count();
        $productTypesCount = ProductType::count();
        $activeFormulas = Formula::where('is_active', true)->count();
        $todayCalculations = Calculation::whereDate('created_at', today())->count();

        $recentCalculations = Calculation::with('productType')
            ->latest()
            ->take(5)
            ->get();

        $productTypes = ProductType::all();

        return view('dashboard', compact(
            'totalCalculations',
            'productTypesCount',
            'activeFormulas',
            'todayCalculations',
            'recentCalculations',
            'productTypes'
        ));
    }
}
