<?php

namespace App\Http\Controllers;

use App\Models\Variable;
use Illuminate\Http\Request;

class VariableController extends Controller
{
    public function index()
    {
        $variables = Variable::all();
        return view('variables.index', compact('variables'));
    }

    public function create()
    {
        return view('variables.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:variables',
            'default_value' => 'required|numeric',
            'unit' => 'required|string|max:20',
            'description' => 'nullable|string'
        ]);

        Variable::create($request->all());

        return redirect()->route('variables.index')
            ->with('success', 'تم إضافة المتغير بنجاح');
    }

    public function edit(Variable $variable)
    {
        return view('variables.edit', compact('variable'));
    }

    public function update(Request $request, Variable $variable)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:variables,name,' . $variable->id,
            'default_value' => 'required|numeric',
            'unit' => 'required|string|max:20',
            'description' => 'nullable|string'
        ]);

        $variable->update($request->all());

        return redirect()->route('variables.index')
            ->with('success', 'تم تحديث المتغير بنجاح');
    }

    public function destroy(Variable $variable)
    {
        $variable->delete();
        return redirect()->route('variables.index')
            ->with('success', 'تم حذف المتغير بنجاح');
    }
}
