<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Calculation extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_type_id',
        'title',
        'input_variables',
        'calculated_results',
        'notes'
    ];

    protected $casts = [
        'input_variables' => 'array',
        'calculated_results' => 'array'
    ];

    public function productType()
    {
        return $this->belongsTo(ProductType::class);
    }
}
