<!-- resources/views/calculations/index.blade.php -->
@extends('layouts.app')

@section('title', 'الحسابات السابقة')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">الحسابات السابقة</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @if ($calculations->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>العنوان</th>
                                            <th>نوع المنتج</th>
                                            <th>المتغيرات المدخلة</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($calculations as $calculation)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $calculation->title }}</td>
                                                <td>
                                                    <span class="badge bg-info">{{ $calculation->productType->name }}</span>
                                                </td>
                                                <td>
                                                    {{-- التعديل: لا تستخدم json_decode لأن input_variables هي بالفعل مصفوفة --}}
                                                    @foreach ($calculation->input_variables as $key => $value)
                                                        <span class="badge bg-secondary me-1">{{ $key }}:
                                                            {{ $value }}</span>
                                                    @endforeach
                                                </td>
                                                <td>{{ $calculation->created_at->format('Y-m-d H:i') }}</td>
                                                <td>
                                                    <a href="{{ route('calculations.show', $calculation->id) }}"
                                                        class="btn btn-sm btn-info">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                    <form action="{{ route('calculations.destroy', $calculation->id) }}"
                                                        method="POST" class="d-inline"
                                                        onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            {{ $calculations->links() }}
                        @else
                            <div class="alert alert-info">
                                لا توجد حسابات سابقة.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
