<!-- resources/views/formulas/index.blade.php -->
@extends('layouts.app')

@section('title', 'إدارة المعادلات')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">إدارة المعادلات</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">قائمة المعادلات</h5>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addFormulaModal">
                            <i class="bi bi-plus"></i> إضافة معادلة
                        </button>
                    </div>
                    <div class="card-body">
                        @if ($formulas->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم المعادلة</th>
                                            <th>نوع المنتج</th>
                                            <th>المعادلة</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($formulas as $formula)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $formula->name }}</td>
                                                <td>{{ $formula->productType->name }}</td>
                                                <td><code>{{ $formula->formula }}</code></td>
                                                <td>
                                                    @if ($formula->is_active)
                                                        <span class="badge bg-success">نشط</span>
                                                    @else
                                                        <span class="badge bg-danger">غير نشط</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                                        data-bs-target="#editFormulaModal" data-id="{{ $formula->id }}"
                                                        data-name="{{ $formula->name }}"
                                                        data-product_type_id="{{ $formula->product_type_id }}"
                                                        data-variable_name="{{ $formula->variable_name }}"
                                                        data-formula="{{ $formula->formula }}"
                                                        data-unit="{{ $formula->unit }}" data-order="{{ $formula->order }}"
                                                        data-is_active="{{ $formula->is_active }}">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <form action="{{ route('formulas.destroy', $formula->id) }}"
                                                        method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('هل أنت متأكد؟')">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="alert alert-info">
                                لا توجد معادلات مضافة بعد.
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إضافة معادلة جديدة</h5>
                    </div>
                    <div class="card-body">
                        <form id="addFormulaForm">
                            @csrf
                            <div class="mb-3">
                                <label for="product_type_id" class="form-label">نوع المنتج</label>
                                <select class="form-select" id="product_type_id" name="product_type_id" required>
                                    <option value="">اختر نوع المنتج</option>
                                    @foreach ($productTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">اسم المعادلة</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                                <small class="text-muted">مثال: حلق علوي، حلق سفلي</small>
                            </div>

                            <div class="mb-3">
                                <label for="variable_name" class="form-label">اسم المتغير الناتج</label>
                                <input type="text" class="form-control" id="variable_name" name="variable_name" required>
                                <small class="text-muted">الاسم الذي سيظهر للنتيجة</small>
                            </div>

                            <div class="mb-3">
                                <label for="formula" class="form-label">المعادلة الرياضية</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="formula" name="formula" required>
                                    <button type="button" class="btn btn-outline-secondary" onclick="showVariablesModal()">
                                        <i class="bi bi-code-slash"></i>
                                    </button>
                                </div>
                                <small class="text-muted">استخدم المتغيرات بين الأقواس {مثل} {الطول} * 2</small>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="unit" class="form-label">الوحدة</label>
                                    <input type="text" class="form-control" id="unit" name="unit" value="mm"
                                        required>
                                </div>
                                <div class="col-md-6">
                                    <label for="order" class="form-label">الترتيب</label>
                                    <input type="number" class="form-control" id="order" name="order" value="0">
                                </div>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="is_active" name="is_active"
                                    value="1" checked>
                                <label class="form-check-label" for="is_active">نشط</label>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">إضافة المعادلة</button>
                        </form>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المتغيرات المتاحة</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-2">
                            <h6>المتغيرات الأساسية:</h6>
                            <div>
                                @foreach (['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد'] as $variable)
                                    <button type="button" class="btn btn-sm btn-outline-primary mb-1"
                                        onclick="insertVariable('{{ $variable }}')">
                                        {{ $variable }}
                                    </button>
                                @endforeach
                            </div>
                        </div>
                        <div class="mb-2">
                            <h6>العمليات الرياضية:</h6>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('+')">+</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('-')">-</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('*')">×</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('/')">÷</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('(')">(</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator(')')">)</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal تعديل المعادلة -->
    <div class="modal fade" id="editFormulaModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تعديل المعادلة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editFormulaForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <input type="hidden" id="edit_id" name="id">

                        <div class="mb-3">
                            <label for="edit_name" class="form-label">اسم المعادلة</label>
                            <input type="text" class="form-control" id="edit_name" name="name" required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_variable_name" class="form-label">اسم المتغير الناتج</label>
                            <input type="text" class="form-control" id="edit_variable_name" name="variable_name"
                                required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_formula" class="form-label">المعادلة الرياضية</label>
                            <input type="text" class="form-control" id="edit_formula" name="formula" required>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="edit_unit" class="form-label">الوحدة</label>
                                <input type="text" class="form-control" id="edit_unit" name="unit" required>
                            </div>
                            <div class="col-md-6">
                                <label for="edit_order" class="form-label">الترتيب</label>
                                <input type="number" class="form-control" id="edit_order" name="order">
                            </div>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="edit_is_active" name="is_active"
                                value="1">
                            <label class="form-check-label" for="edit_is_active">نشط</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal المتغيرات -->
    <div class="modal fade" id="variablesModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">إدراج متغير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        @foreach (['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد'] as $variable)
                            <div class="col-6 mb-2">
                                <button type="button" class="btn btn-outline-primary w-100"
                                    onclick="insertVariableToField('{{ $variable }}')">
                                    {{ $variable }}
                                </button>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // إضافة معادلة جديدة
        $('#addFormulaForm').submit(function(e) {
            e.preventDefault();

            const formData = $(this).serialize();

            $.ajax({
                url: '{{ route('formulas.store') }}',
                method: 'POST',
                data: formData,
                success: function(response) {
                    location.reload();
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        alert('يرجى تصحيح الأخطاء: ' + JSON.stringify(errors));
                    }
                }
            });
        });

        // تعديل معادلة
        $('#editFormulaModal').on('show.bs.modal', function(event) {
            const button = $(event.relatedTarget);
            const formulaId = button.data('id');

            $('#edit_id').val(formulaId);
            $('#edit_name').val(button.data('name'));
            $('#edit_variable_name').val(button.data('variable_name'));
            $('#edit_formula').val(button.data('formula'));
            $('#edit_unit').val(button.data('unit'));
            $('#edit_order').val(button.data('order'));
            $('#edit_is_active').prop('checked', button.data('is_active') == 1);

            $('#editFormulaForm').attr('action', '/formulas/' + formulaId);
        });

        // إدراج متغير
        function insertVariable(variable) {
            const formulaField = $('#formula');
            const currentValue = formulaField.val();
            formulaField.val(currentValue + '{' + variable + '}');
        }

        function insertOperator(operator) {
            const formulaField = $('#formula');
            const currentValue = formulaField.val();
            formulaField.val(currentValue + operator);
        }

        function showVariablesModal() {
            $('#variablesModal').modal('show');
        }

        function insertVariableToField(variable) {
            const activeField = document.activeElement;
            if (activeField && (activeField.id === 'formula' || activeField.id === 'edit_formula')) {
                const start = activeField.selectionStart;
                const end = activeField.selectionEnd;
                const text = activeField.value;
                activeField.value = text.substring(0, start) + '{' + variable + '}' + text.substring(end);
                activeField.focus();
                activeField.setSelectionRange(start + variable.length + 2, start + variable.length + 2);
            }
            $('#variablesModal').modal('hide');
        }
    </script>
@endpush
