@extends('layouts.app')

@section('title', 'المساعدة والتعليمات')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">المساعدة والتعليمات</h2>
            </div>
        </div>

        <div class="row">
            <!-- قائمة المحتويات -->
            <div class="col-md-3">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">قائمة المحتويات</h5>
                    </div>
                    <div class="list-group list-group-flush">
                        <a href="#getting-started" class="list-group-item list-group-item-action">
                            <i class="bi bi-play-circle"></i> البدء السريع
                        </a>
                        <a href="#calculations" class="list-group-item list-group-item-action">
                            <i class="bi bi-calculator"></i> إجراء الحسابات
                        </a>
                        <a href="#formulas" class="list-group-item list-group-item-action">
                            <i class="bi bi-sliders"></i> إدارة المعادلات
                        </a>
                        <a href="#variables" class="list-group-item list-group-item-action">
                            <i class="bi bi-input-cursor-text"></i> المتغيرات
                        </a>
                        <a href="#product-types" class="list-group-item list-group-item-action">
                            <i class="bi bi-box"></i> أنواع المنتجات
                        </a>
                        <a href="#reports" class="list-group-item list-group-item-action">
                            <i class="bi bi-graph-up"></i> التقارير
                        </a>
                        <a href="#faq" class="list-group-item list-group-item-action">
                            <i class="bi bi-question-circle"></i> الأسئلة الشائعة
                        </a>
                    </div>
                </div>

                <!-- روابط سريعة -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">روابط سريعة</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('calculations.create') }}" class="btn btn-outline-primary">
                                <i class="bi bi-calculator"></i> بدء حساب جديد
                            </a>
                            <a href="{{ route('formulas.index') }}" class="btn btn-outline-success">
                                <i class="bi bi-sliders"></i> إدارة المعادلات
                            </a>
                            <a href="{{ route('reports.index') }}" class="btn btn-outline-info">
                                <i class="bi bi-graph-up"></i> عرض التقارير
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- محتوى المساعدة -->
            <div class="col-md-9">
                <div class="card">
                    <div class="card-body">
                        <!-- البدء السريع -->
                        <section id="getting-started" class="mb-5">
                            <h4 class="mb-3"><i class="bi bi-play-circle text-primary"></i> البدء السريع</h4>
                            <div class="alert alert-info">
                                <p>مرحباً بك في نظام حساب مقاسات الألمنيوم. يهدف هذا النظام إلى تسهيل عملية حساب مقاسات
                                    الألمنيوم للمعامل والمصانع.</p>
                            </div>

                            <h5>خطوات البدء:</h5>
                            <ol>
                                <li>قم بتسجيل الدخول إلى النظام</li>
                                <li>اذهب إلى "لوحة التحكم" للاطلاع على الإحصائيات</li>
                                <li>انقر على "حساب جديد" لبدء أول حساب لك</li>
                                <li>اختر نوع المنتج المراد حسابه</li>
                                <li>أدخل البيانات المطلوبة</li>
                                <li>انقر على "حساب النتائج"</li>
                            </ol>

                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="card border-primary">
                                        <div class="card-body">
                                            <h6><i class="bi bi-lightbulb text-warning"></i> نصائح سريعة:</h6>
                                            <ul>
                                                <li>احفظ حساباتك للرجوع إليها لاحقاً</li>
                                                <li>استخدم المعادلات المسبقة لتسريع العمل</li>
                                                <li>يمكنك تعديل المعادلات حسب احتياجاتك</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card border-success">
                                        <div class="card-body">
                                            <h6><i class="bi bi-clock-history text-success"></i> توفير الوقت:</h6>
                                            <ul>
                                                <li>استخدم النسخ المسبق للحسابات المتشابهة</li>
                                                <li>أنشئ قوالب للمشاريع المتكررة</li>
                                                <li>استخدم التقارير لمتابعة الإنتاجية</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>

                        <!-- إجراء الحسابات -->
                        <section id="calculations" class="mb-5">
                            <h4 class="mb-3"><i class="bi bi-calculator text-success"></i> إجراء الحسابات</h4>

                            <h5>كيفية إجراء حساب جديد:</h5>
                            <div class="accordion mb-3" id="calculationGuide">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#step1">
                                            الخطوة 1: اختيار نوع المنتج
                                        </button>
                                    </h2>
                                    <div id="step1" class="accordion-collapse collapse show"
                                        data-bs-parent="#calculationGuide">
                                        <div class="accordion-body">
                                            <p>اختر نوع المنتج الذي تريد حسابه من القائمة المنسدلة. لكل نوع منتج متغيرات
                                                ومعادلات خاصة به.</p>
                                            <img src="{{ asset('images/help/product-type.png') }}" alt="اختيار نوع المنتج"
                                                class="img-fluid rounded border" style="max-height: 200px;">
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#step2">
                                            الخطوة 2: إدخال البيانات
                                        </button>
                                    </h2>
                                    <div id="step2" class="accordion-collapse collapse"
                                        data-bs-parent="#calculationGuide">
                                        <div class="accordion-body">
                                            <p>أدخل قيم المتغيرات المطلوبة. يمكنك النقر على المتغيرات من الشريط الجانبي
                                                لإضافتها تلقائياً.</p>
                                            <img src="{{ asset('images/help/input-variables.png') }}" alt="إدخال البيانات"
                                                class="img-fluid rounded border" style="max-height: 200px;">
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#step3">
                                            الخطوة 3: حساب النتائج
                                        </button>
                                    </h2>
                                    <div id="step3" class="accordion-collapse collapse"
                                        data-bs-parent="#calculationGuide">
                                        <div class="accordion-body">
                                            <p>انقر على زر "حساب النتائج" وسيتم عرض النتائج المحسوبة في الجانب الأيمن.</p>
                                            <img src="{{ asset('images/help/calculate-results.png') }}" alt="حساب النتائج"
                                                class="img-fluid rounded border" style="max-height: 200px;">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h5 class="mt-4">أنواع الحسابات المتاحة:</h5>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bi bi-window fs-1 text-primary"></i>
                                            <h6>النوافذ</h6>
                                            <small class="text-muted">حساب مقاسات النوافذ بأنواعها</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bi bi-door-closed fs-1 text-success"></i>
                                            <h6>الأبواب</h6>
                                            <small class="text-muted">حساب مقاسات الأبواب الداخلية والخارجية</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bi bi-grid-3x3-gap fs-1 text-warning"></i>
                                            <h6>الواجهات</h6>
                                            <small class="text-muted">حساب مقاسات واجهات الألمنيوم</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>

                        <!-- إدارة المعادلات -->
                        <section id="formulas" class="mb-5">
                            <h4 class="mb-3"><i class="bi bi-sliders text-warning"></i> إدارة المعادلات</h4>

                            <p>يمكنك إدارة المعادلات الرياضية المستخدمة في الحسابات من خلال صفحة "إدارة المعادلات".</p>

                            <h5>إنشاء معادلة جديدة:</h5>
                            <pre class="bg-light p-3 rounded"><code>صيغة المعادلة: {الطول} * 2 + {العرض} * 2
المتغيرات: استخدم الأقواس {} حول اسم المتغير
الأمثلة:
- محيط النافذة: ({الطول} + {العرض}) * 2
- مساحة الباب: {الطول} * {العرض}
- طول الحلق: {الطول} - {السماكة} * 2</code></pre>

                            <h5 class="mt-4">أنواع المعادلات الشائعة:</h5>
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="table-primary">
                                        <th>اسم المعادلة</th>
                                        <th>الصيغة</th>
                                        <th>الوصف</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>حلق علوي</td>
                                        <td><code>{العرض} - {السماكة} * 2</code></td>
                                        <td>حساب طول الحلق العلوي</td>
                                    </tr>
                                    <tr>
                                        <td>حلق سفلي</td>
                                        <td><code>{العرض} - {السماكة} * 2</code></td>
                                        <td>حساب طول الحلق السفلي</td>
                                    </tr>
                                    <tr>
                                        <td>حلق جانبي</td>
                                        <td><code>{الطول} - {السماكة} * 2</code></td>
                                        <td>حساب طول الحلق الجانبي</td>
                                    </tr>
                                    <tr>
                                        <td>المساحة</td>
                                        <td><code>{الطول} * {العرض}</code></td>
                                        <td>حساب المساحة الكلية</td>
                                    </tr>
                                    <tr>
                                        <td>المحيط</td>
                                        <td><code>({الطول} + {العرض}) * 2</code></td>
                                        <td>حساب المحيط الكلي</td>
                                    </tr>
                                </tbody>
                            </table>
                        </section>

                        <!-- الأسئلة الشائعة -->
                        <section id="faq">
                            <h4 class="mb-3"><i class="bi bi-question-circle text-info"></i> الأسئلة الشائعة</h4>

                            <div class="accordion" id="faqAccordion">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#faq1">
                                            كيف أضيف نوع منتج جديد؟
                                        </button>
                                    </h2>
                                    <div id="faq1" class="accordion-collapse collapse show"
                                        data-bs-parent="#faqAccordion">
                                        <div class="accordion-body">
                                            <p>لإضافة نوع منتج جديد:</p>
                                            <ol>
                                                <li>اذهب إلى صفحة "إدارة أنواع المنتجات"</li>
                                                <li>انقر على زر "إضافة نوع"</li>
                                                <li>أدخل اسم النوع والكود والوصف</li>
                                                <li>حدد المتغيرات الافتراضية لهذا النوع</li>
                                                <li>انقر على حفظ</li>
                                            </ol>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#faq2">
                                            هل يمكنني تعديل معادلة موجودة؟
                                        </button>
                                    </h2>
                                    <div id="faq2" class="accordion-collapse collapse"
                                        data-bs-parent="#faqAccordion">
                                        <div class="accordion-body">
                                            <p>نعم، يمكنك تعديل أي معادلة من خلال:</p>
                                            <ul>
                                                <li>الذهاب إلى صفحة "إدارة المعادلات"</li>
                                                <li>النقر على أيقونة التعديل بجانب المعادلة</li>
                                                <li>تعديل الصيغة أو الاسم أو الوحدة</li>
                                                <li>حفظ التغييرات</li>
                                            </ul>
                                            <div class="alert alert-warning">
                                                <small><i class="bi bi-exclamation-triangle"></i> ملاحظة: التعديل لن يؤثر
                                                    على الحسابات السابقة</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#faq3">
                                            كيف أحفظ الحساب؟
                                        </button>
                                    </h2>
                                    <div id="faq3" class="accordion-collapse collapse"
                                        data-bs-parent="#faqAccordion">
                                        <div class="accordion-body">
                                            <p>يتم حفظ الحسابات تلقائياً عند النقر على "حساب النتائج". يمكنك:</p>
                                            <ul>
                                                <li>الاطلاع على الحسابات السابقة من صفحة "الحسابات"</li>
                                                <li>نسخ أي حساب لإنشاء حساب جديد بناء عليه</li>
                                                <li>طباعة الحساب أو تصديره إلى PDF</li>
                                                <li>حذف الحسابات غير المرغوب فيها</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#faq4">
                                            هل النظام يدعم الوحدات المختلفة؟
                                        </button>
                                    </h2>
                                    <div id="faq4" class="accordion-collapse collapse"
                                        data-bs-parent="#faqAccordion">
                                        <div class="accordion-body">
                                            <p>نعم، يدعم النظام عدة وحدات قياس:</p>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h6>وحدات الطول:</h6>
                                                    <ul>
                                                        <li>مليمتر (mm) - افتراضي</li>
                                                        <li>سنتيمتر (cm)</li>
                                                        <li>متر (m)</li>
                                                    </ul>
                                                </div>
                                                <div class="col-md-6">
                                                    <h6>وحدات الوزن:</h6>
                                                    <ul>
                                                        <li>جرام (g)</li>
                                                        <li>كيلوجرام (kg)</li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <p>يمكنك تغيير الوحدات من صفحة "الإعدادات".</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>

                        <!-- اتصل بنا -->
                        <div class="card mt-5 border-primary">
                            <div class="card-header bg-primary text-white">
                                <h5 class="card-title mb-0"><i class="bi bi-headset"></i> الدعم الفني</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>تواصل معنا:</h6>
                                        <ul class="list-unstyled">
                                            <li><i class="bi bi-envelope"></i> البريد الإلكتروني:
                                                support@aluminum-system.com</li>
                                            <li><i class="bi bi-telephone"></i> الهاتف: +966 123 456 789</li>
                                            <li><i class="bi bi-clock"></i> ساعات العمل: 8 صباحاً - 5 مساءً</li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>اقتراحات وتحسينات:</h6>
                                        <p>نرحب باقتراحاتكم وآرائكم لتطوير النظام وتحسين تجربة المستخدم.</p>
                                        <a href="mailto:suggestions@aluminum-system.com" class="btn btn-outline-primary">
                                            <i class="bi bi-lightbulb"></i> إرسال اقتراح
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        section {
            scroll-margin-top: 20px;
        }

        .accordion-button:not(.collapsed) {
            background-color: #e7f1ff;
            color: #0d6efd;
        }

        pre code {
            font-family: 'Courier New', monospace;
            font-size: 14px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        // التنقل السلس بين الأقسام
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('href');
                if (targetId === '#') return;

                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    window.scrollTo({
                        top: targetElement.offsetTop - 80,
                        behavior: 'smooth'
                    });
                }
            });
        });

        // تمييز القسم النشط أثناء التمرير
        window.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section');
            const navLinks = document.querySelectorAll('.list-group-item');

            let currentSection = '';
            sections.forEach(section => {
                const sectionTop = section.offsetTop - 100;
                const sectionHeight = section.clientHeight;
                if (scrollY >= sectionTop && scrollY < sectionTop + sectionHeight) {
                    currentSection = '#' + section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === currentSection) {
                    link.classList.add('active');
                }
            });
        });
    </script>
@endpush
