@extends('layouts.app')

@section('title', 'الإعدادات')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">إعدادات النظام</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3">
                <!-- قائمة الإعدادات -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">الإعدادات</h5>
                    </div>
                    <div class="list-group list-group-flush">
                        <a href="#general" class="list-group-item list-group-item-action active" data-bs-toggle="tab">
                            <i class="bi bi-gear"></i> الإعدادات العامة
                        </a>
                        <a href="#units" class="list-group-item list-group-item-action" data-bs-toggle="tab">
                            <i class="bi bi-rulers"></i> الوحدات
                        </a>
                        <a href="#variables" class="list-group-item list-group-item-action" data-bs-toggle="tab">
                            <i class="bi bi-input-cursor-text"></i> المتغيرات
                        </a>
                        <a href="#backup" class="list-group-item list-group-item-action" data-bs-toggle="tab">
                            <i class="bi bi-database"></i> النسخ الاحتياطي
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="tab-content">
                    <!-- تبويب الإعدادات العامة -->
                    <div class="tab-pane fade show active" id="general">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">الإعدادات العامة</h5>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('settings.update') }}" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="company_name" class="form-label">اسم الشركة</label>
                                                <input type="text" class="form-control" id="company_name"
                                                    name="company_name"
                                                    value="{{ old('company_name', $settings->company_name ?? '') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="currency" class="form-label">العملة</label>
                                                <select class="form-select" id="currency" name="currency">
                                                    <option value="ريال"
                                                        {{ ($settings->currency ?? '') == 'ريال' ? 'selected' : '' }}>ريال
                                                        سعودي</option>
                                                    <option value="دينار"
                                                        {{ ($settings->currency ?? '') == 'دينار' ? 'selected' : '' }}>دينار
                                                        كويتي</option>
                                                    <option value="درهم"
                                                        {{ ($settings->currency ?? '') == 'درهم' ? 'selected' : '' }}>درهم
                                                        إماراتي</option>
                                                    <option value="دولار"
                                                        {{ ($settings->currency ?? '') == 'دولار' ? 'selected' : '' }}>دولار
                                                        أمريكي</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="default_material_price" class="form-label">سعر المادة الافتراضي (لكل
                                            متر)</label>
                                        <input type="number" class="form-control" id="default_material_price"
                                            name="default_material_price" step="0.01"
                                            value="{{ old('default_material_price', $settings->default_material_price ?? '0') }}">
                                    </div>

                                    <div class="mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="auto_save" name="auto_save"
                                                value="1" {{ $settings->auto_save ?? false ? 'checked' : '' }}>
                                            <label class="form-check-label" for="auto_save">
                                                الحفظ التلقائي للحسابات
                                            </label>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="show_formulas"
                                                name="show_formulas" value="1"
                                                {{ $settings->show_formulas ?? true ? 'checked' : '' }}>
                                            <label class="form-check-label" for="show_formulas">
                                                عرض المعادلات أثناء الحساب
                                            </label>
                                        </div>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save"></i> حفظ الإعدادات
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- تبويب الوحدات -->
                    <div class="tab-pane fade" id="units">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">إدارة الوحدات</h5>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('settings.units') }}" method="POST">
                                    @csrf

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="length_unit" class="form-label">وحدة الطول</label>
                                                <select class="form-select" id="length_unit" name="length_unit">
                                                    <option value="mm"
                                                        {{ ($settings->length_unit ?? 'mm') == 'mm' ? 'selected' : '' }}>
                                                        مليمتر (mm)</option>
                                                    <option value="cm"
                                                        {{ ($settings->length_unit ?? '') == 'cm' ? 'selected' : '' }}>
                                                        سنتيمتر (cm)</option>
                                                    <option value="m"
                                                        {{ ($settings->length_unit ?? '') == 'm' ? 'selected' : '' }}>متر
                                                        (m)</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="weight_unit" class="form-label">وحدة الوزن</label>
                                                <select class="form-select" id="weight_unit" name="weight_unit">
                                                    <option value="g"
                                                        {{ ($settings->weight_unit ?? 'g') == 'g' ? 'selected' : '' }}>جرام
                                                        (g)</option>
                                                    <option value="kg"
                                                        {{ ($settings->weight_unit ?? '') == 'kg' ? 'selected' : '' }}>
                                                        كيلوجرام (kg)</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="volume_unit" class="form-label">وحدة الحجم</label>
                                                <select class="form-select" id="volume_unit" name="volume_unit">
                                                    <option value="mm3"
                                                        {{ ($settings->volume_unit ?? 'mm3') == 'mm3' ? 'selected' : '' }}>
                                                        مليمتر مكعب (mm³)</option>
                                                    <option value="cm3"
                                                        {{ ($settings->volume_unit ?? '') == 'cm3' ? 'selected' : '' }}>
                                                        سنتيمتر مكعب (cm³)</option>
                                                    <option value="m3"
                                                        {{ ($settings->volume_unit ?? '') == 'm3' ? 'selected' : '' }}>متر
                                                        مكعب (m³)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-save"></i> حفظ الوحدات
                                        </button>
                                    </div>
                                </form>

                                <!-- جدول تحويل الوحدات -->
                                <div class="mt-4">
                                    <h6>جدول تحويل الوحدات:</h6>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>من</th>
                                                    <th>إلى</th>
                                                    <th>معامل التحويل</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1 متر (m)</td>
                                                    <td>100 سنتيمتر (cm)</td>
                                                    <td>× 100</td>
                                                </tr>
                                                <tr>
                                                    <td>1 متر (m)</td>
                                                    <td>1000 مليمتر (mm)</td>
                                                    <td>× 1000</td>
                                                </tr>
                                                <tr>
                                                    <td>1 كيلوجرام (kg)</td>
                                                    <td>1000 جرام (g)</td>
                                                    <td>× 1000</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تبويب المتغيرات -->
                    <div class="tab-pane fade" id="variables">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">المتغيرات المخصصة</h5>
                                <button class="btn btn-sm btn-primary" data-bs-toggle="modal"
                                    data-bs-target="#addVariableModal">
                                    <i class="bi bi-plus"></i> إضافة متغير
                                </button>
                            </div>
                            <div class="card-body">
                                @if ($customVariables->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>اسم المتغير</th>
                                                    <th>القيمة الافتراضية</th>
                                                    <th>الوحدة</th>
                                                    <th>الوصف</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($customVariables as $variable)
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>
                                                            <code>{{ $variable->name }}</code>
                                                        </td>
                                                        <td>{{ $variable->default_value }}</td>
                                                        <td>{{ $variable->unit }}</td>
                                                        <td>{{ $variable->description }}</td>
                                                        <td>
                                                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                                                data-bs-target="#editVariableModal"
                                                                data-id="{{ $variable->id }}"
                                                                data-name="{{ $variable->name }}"
                                                                data-default_value="{{ $variable->default_value }}"
                                                                data-unit="{{ $variable->unit }}"
                                                                data-description="{{ $variable->description }}">
                                                                <i class="bi bi-pencil"></i>
                                                            </button>
                                                            <form action="{{ route('variables.destroy', $variable->id) }}"
                                                                method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-sm btn-danger"
                                                                    onclick="return confirm('هل أنت متأكد؟')">
                                                                    <i class="bi bi-trash"></i>
                                                                </button>
                                                            </form>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        <i class="bi bi-info-circle"></i>
                                        لا توجد متغيرات مخصصة مضافة بعد.
                                    </div>
                                @endif

                                <!-- المتغيرات النظامية -->
                                <div class="mt-4">
                                    <h6>المتغيرات النظامية:</h6>
                                    <div class="row">
                                        @foreach (['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد'] as $variable)
                                            <div class="col-md-2 col-sm-4 mb-2">
                                                <div class="card border-primary">
                                                    <div class="card-body text-center p-2">
                                                        <strong class="d-block">{{ $variable }}</strong>
                                                        <small class="text-muted">متغير نظامي</small>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تبويب النسخ الاحتياطي -->
                    <div class="tab-pane fade" id="backup">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">النسخ الاحتياطي</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card border-primary">
                                            <div class="card-body text-center">
                                                <i class="bi bi-download fs-1 text-primary"></i>
                                                <h5 class="card-title mt-3">تصدير البيانات</h5>
                                                <p class="card-text">تصدير جميع البيانات إلى ملف يمكن استعادته لاحقاً</p>
                                                <div class="d-grid gap-2">
                                                    <a href="{{ route('backup.export') }}" class="btn btn-primary">
                                                        <i class="bi bi-file-earmark-arrow-down"></i> تصدير البيانات
                                                    </a>
                                                    <a href="{{ route('backup.export-calculations') }}"
                                                        class="btn btn-outline-primary">
                                                        <i class="bi bi-calculator"></i> تصدير الحسابات فقط
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="card border-success">
                                            <div class="card-body text-center">
                                                <i class="bi bi-upload fs-1 text-success"></i>
                                                <h5 class="card-title mt-3">استيراد البيانات</h5>
                                                <p class="card-text">استعادة البيانات من ملف نسخ احتياطي سابق</p>
                                                <form action="{{ route('backup.import') }}" method="POST"
                                                    enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="mb-3">
                                                        <input type="file" class="form-control" name="backup_file"
                                                            accept=".json,.sql" required>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="submit" class="btn btn-success">
                                                            <i class="bi bi-file-earmark-arrow-up"></i> استيراد البيانات
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- معلومات النسخ الاحتياطي -->
                                <div class="mt-4">
                                    <div class="alert alert-warning">
                                        <h6><i class="bi bi-exclamation-triangle"></i> معلومات مهمة:</h6>
                                        <ul>
                                            <li>يُنصح بعمل نسخة احتياطية أسبوعياً</li>
                                            <li>احفظ ملف النسخ الاحتياطي في مكان آمن</li>
                                            <li>الاستيراد سيستبدل البيانات الحالية</li>
                                            <li>آخر نسخة احتياطية: {{ $lastBackup ?? 'لم يتم عمل نسخة احتياطية بعد' }}</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal إضافة متغير -->
    <div class="modal fade" id="addVariableModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">إضافة متغير مخصص</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('variables.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="var_name" class="form-label">اسم المتغير</label>
                            <input type="text" class="form-control" id="var_name" name="name" required>
                            <small class="text-muted">استخدم اسم فريد بدون مسافات (مثل: سماكة_الزجاج)</small>
                        </div>

                        <div class="mb-3">
                            <label for="var_default_value" class="form-label">القيمة الافتراضية</label>
                            <input type="number" class="form-control" id="var_default_value" name="default_value"
                                step="0.01" value="0">
                        </div>

                        <div class="mb-3">
                            <label for="var_unit" class="form-label">الوحدة</label>
                            <input type="text" class="form-control" id="var_unit" name="unit" value="mm">
                        </div>

                        <div class="mb-3">
                            <label for="var_description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="var_description" name="description" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">إضافة</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal تعديل متغير -->
    <div class="modal fade" id="editVariableModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تعديل المتغير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editVariableForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <input type="hidden" id="edit_var_id" name="id">

                        <div class="mb-3">
                            <label for="edit_var_name" class="form-label">اسم المتغير</label>
                            <input type="text" class="form-control" id="edit_var_name" name="name" required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_var_default_value" class="form-label">القيمة الافتراضية</label>
                            <input type="number" class="form-control" id="edit_var_default_value" name="default_value"
                                step="0.01">
                        </div>

                        <div class="mb-3">
                            <label for="edit_var_unit" class="form-label">الوحدة</label>
                            <input type="text" class="form-control" id="edit_var_unit" name="unit">
                        </div>

                        <div class="mb-3">
                            <label for="edit_var_description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="edit_var_description" name="description" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .tab-pane {
            animation: fadeIn 0.3s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }
    </style>
@endpush

@push('scripts')
    <script>
        // تفعيل تبويبات الإعدادات
        $(document).ready(function() {
            // حفظ التبويب النشط في localStorage
            $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function(e) {
                localStorage.setItem('activeTab', $(e.target).attr('href'));
            });

            // استعادة التبويب النشط
            const activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });

        // فتح مودال تعديل المتغير
        $('#editVariableModal').on('show.bs.modal', function(event) {
            const button = $(event.relatedTarget);
            const variableId = button.data('id');

            $('#edit_var_id').val(variableId);
            $('#edit_var_name').val(button.data('name'));
            $('#edit_var_default_value').val(button.data('default_value'));
            $('#edit_var_unit').val(button.data('unit'));
            $('#edit_var_description').val(button.data('description'));

            $('#editVariableForm').attr('action', `/variables/${variableId}`);
        });
    </script>
@endpush
