<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CalculationController;
use App\Http\Controllers\FormulaController;
use App\Http\Controllers\ProductTypeController;

Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

Route::resource('calculations', CalculationController::class);
Route::resource('formulas', FormulaController::class);
Route::resource('product-types', ProductTypeController::class)->except(['show']);

Route::get('/formulas/product-type/{productTypeId}', [FormulaController::class, 'getByProductType']);
