<!-- resources/views/calculations/show.blade.php -->


<?php $__env->startSection('title', 'تفاصيل الحساب'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('calculations.index')); ?>">الحسابات</a></li>
                        <li class="breadcrumb-item active" aria-current="page">تفاصيل الحساب</li>
                    </ol>
                </nav>

                <h2 class="mb-4">تفاصيل الحساب</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">النتائج المحسوبة</h5>
                        <span class="badge bg-primary"><?php echo e($calculation->productType->name); ?></span>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6>معلومات الحساب:</h6>
                                <p><strong>العنوان:</strong> <?php echo e($calculation->title); ?></p>
                                <p><strong>التاريخ:</strong> <?php echo e($calculation->created_at->format('Y-m-d H:i')); ?></p>
                            </div>
                            <div class="col-md-6">
                                <?php if($calculation->notes): ?>
                                    <h6>ملاحظات:</h6>
                                    <div class="alert alert-info">
                                        <?php echo e($calculation->notes); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <h6 class="mb-3">المتغيرات المدخلة:</h6>
                        <div class="row mb-4">
                            
                            <?php $__currentLoopData = $calculation->input_variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 col-sm-4 mb-2">
                                    <div class="card border-primary">
                                        <div class="card-body text-center">
                                            <h6 class="card-title"><?php echo e($key); ?></h6>
                                            <h4 class="text-primary"><?php echo e($value); ?></h4>
                                            <small class="text-muted">mm</small>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <h6 class="mb-3">النتائج المحسوبة:</h6>
                        <div class="row">
                            
                            <?php $__currentLoopData = $calculation->calculated_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 col-sm-6 mb-3">
                                    <div class="card border-success">
                                        <div class="card-body">
                                            <h6 class="card-title"><?php echo e($result['name']); ?></h6>
                                            <h4 class="text-success"><?php echo e($result['value']); ?> <?php echo e($result['unit']); ?></h4>
                                            <small class="text-muted">
                                                <code><?php echo e($result['formula']); ?></code>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- خيارات الحساب -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">خيارات الحساب</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('calculations.create')); ?>?duplicate=<?php echo e($calculation->id); ?>"
                                class="btn btn-primary">
                                <i class="bi bi-copy"></i> نسخ الحساب
                            </a>

                            <button class="btn btn-success" onclick="printCalculation()">
                                <i class="bi bi-printer"></i> طباعة النتائج
                            </button>

                            <a href="javascript:void(0)" class="btn btn-info" onclick="shareCalculation()">
                                <i class="bi bi-share"></i> مشاركة النتائج
                            </a>
                        </div>

                        <!-- ملخص الحساب -->
                        <div class="mt-4">
                            <h6>ملخص الحساب:</h6>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>عدد المتغيرات:</span>
                                    <span class="badge bg-primary"><?php echo e(count($calculation->input_variables)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>عدد النتائج:</span>
                                    <span class="badge bg-success"><?php echo e(count($calculation->calculated_results)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>نوع المنتج:</span>
                                    <span><?php echo e($calculation->productType->name); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>تاريخ الإنشاء:</span>
                                    <span><?php echo e($calculation->created_at->format('Y-m-d')); ?></span>
                                </li>
                            </ul>
                        </div>

                        <!-- إجراءات إدارية -->
                        <div class="mt-4">
                            <h6>إجراءات إدارية:</h6>
                            <div class="d-grid gap-2">
                                <form action="<?php echo e(route('calculations.destroy', $calculation->id)); ?>" method="POST"
                                    onsubmit="return confirm('هل أنت متأكد من حذف هذا الحساب؟')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="bi bi-trash"></i> حذف الحساب
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- معادلات مستخدمة -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المعادلات المستخدمة</h5>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $calculation->calculated_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="alert alert-light mb-2">
                                <small><strong><?php echo e($result['name']); ?>:</strong></small>
                                <br>
                                <small><code class="text-dark"><?php echo e($result['formula']); ?></code></small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- نموذج نسخ الحساب -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إنشاء حساب مشابه</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('calculations.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="duplicate_id" value="<?php echo e($calculation->id); ?>">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="new_title" class="form-label">عنوان جديد</label>
                                        <input type="text" class="form-control" id="new_title" name="title"
                                            value="نسخة من <?php echo e($calculation->title); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="new_notes" class="form-label">ملاحظات جديدة</label>
                                        <textarea class="form-control" id="new_notes" name="notes" rows="1"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-files"></i> إنشاء نسخة جديدة
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- منطقة الطباعة -->
    <div id="printArea" style="display: none;">
        <div style="padding: 20px; font-family: Arial, sans-serif;">
            <h2 style="text-align: center; color: #2c3e50;">تقرير حساب الألمنيوم</h2>
            <hr>

            <h4>معلومات الحساب:</h4>
            <p><strong>العنوان:</strong> <?php echo e($calculation->title); ?></p>
            <p><strong>نوع المنتج:</strong> <?php echo e($calculation->productType->name); ?></p>
            <p><strong>التاريخ:</strong> <?php echo e($calculation->created_at->format('Y-m-d H:i')); ?></p>

            <?php if($calculation->notes): ?>
                <p><strong>ملاحظات:</strong> <?php echo e($calculation->notes); ?></p>
            <?php endif; ?>

            <hr>

            <h4>المتغيرات المدخلة:</h4>
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                <tr style="background-color: #f8f9fa;">
                    <th style="border: 1px solid #ddd; padding: 8px;">المتغير</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">القيمة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">الوحدة</th>
                </tr>
                <?php $__currentLoopData = $calculation->input_variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($key); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($value); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;">mm</td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>

            <h4>النتائج المحسوبة:</h4>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="background-color: #f8f9fa;">
                    <th style="border: 1px solid #ddd; padding: 8px;">المعيار</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">النتيجة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">الوحدة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">المعادلة</th>
                </tr>
                <?php $__currentLoopData = $calculation->calculated_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($result['name']); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($result['value']); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($result['unit']); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><code><?php echo e($result['formula']); ?></code></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>

            <hr>
            <p style="text-align: center; color: #666; margin-top: 30px;">
                تم إنشاء هذا التقرير بواسطة نظام حساب الألمنيوم - <?php echo e(date('Y-m-d H:i')); ?>

            </p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function printCalculation() {
            const printContent = document.getElementById('printArea').innerHTML;
            const originalContent = document.body.innerHTML;

            document.body.innerHTML = printContent;
            window.print();
            document.body.innerHTML = originalContent;
            location.reload();
        }

        function shareCalculation() {
            if (navigator.share) {
                navigator.share({
                    title: 'حساب الألمنيوم: <?php echo e($calculation->title); ?>',
                    text: 'تفاصيل حساب الألمنيوم من نظام إدارة المعمل',
                    url: window.location.href
                });
            } else {
                // نسخ الرابط إلى الحافظة
                navigator.clipboard.writeText(window.location.href).then(() => {
                    alert('تم نسخ رابط الحساب إلى الحافظة');
                });
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\خالي رفيق\aluminum-factory\resources\views/calculations/show.blade.php ENDPATH**/ ?>