<!-- resources/views/product-types/index.blade.php -->


<?php $__env->startSection('title', 'إدارة أنواع المنتجات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">إدارة أنواع المنتجات</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">قائمة أنواع المنتجات</h5>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addProductTypeModal">
                            <i class="bi bi-plus"></i> إضافة نوع
                        </button>
                    </div>
                    <div class="card-body">
                        <?php if($productTypes->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>الاسم</th>
                                            <th>الكود</th>
                                            <th>الوصف</th>
                                            <th>المتغيرات الافتراضية</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $productTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td>
                                                    <strong><?php echo e($productType->name); ?></strong>
                                                </td>
                                                <td>
                                                    <code><?php echo e($productType->code); ?></code>
                                                </td>
                                                <td>
                                                    <?php echo e(Str::limit($productType->description, 50)); ?>

                                                </td>
                                                <td>
                                                    <?php
                                                        $defaultVars =
                                                            json_decode($productType->default_variables, true) ?? [];
                                                    ?>
                                                    <?php $__currentLoopData = $defaultVars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $var): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge bg-secondary me-1"><?php echo e($var); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                                        data-bs-target="#editProductTypeModal"
                                                        data-id="<?php echo e($productType->id); ?>"
                                                        data-name="<?php echo e($productType->name); ?>"
                                                        data-code="<?php echo e($productType->code); ?>"
                                                        data-description="<?php echo e($productType->description); ?>"
                                                        data-default_variables="<?php echo e($productType->default_variables); ?>">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <form action="<?php echo e(route('product-types.destroy', $productType->id)); ?>"
                                                        method="POST" class="d-inline"
                                                        onsubmit="return confirm('هل أنت متأكد؟ سيتم حذف جميع المعادلات المرتبطة')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                لا توجد أنواع منتجات مضافة بعد.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المتغيرات المتاحة</h5>
                    </div>
                    <div class="card-body">
                        <div id="availableVariablesList">
                            <div class="mb-3">
                                <h6>المتغيرات الأساسية:</h6>
                                <div>
                                    <?php $__currentLoopData = ['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد', 'الوزن', 'الكلفة', 'الكمية']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <button type="button" class="btn btn-sm btn-outline-primary mb-1"
                                            onclick="addToDefaultVariables('<?php echo e($variable); ?>')">
                                            <?php echo e($variable); ?>

                                        </button>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="mb-3">
                                <h6>إضافة متغير مخصص:</h6>
                                <div class="input-group mb-2">
                                    <input type="text" class="form-control" id="customVariable"
                                        placeholder="اسم المتغير">
                                    <button class="btn btn-outline-success" type="button" onclick="addCustomVariable()">
                                        <i class="bi bi-plus"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal إضافة نوع منتج -->
    <div class="modal fade" id="addProductTypeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">إضافة نوع منتج جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('product-types.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="name" class="form-label">اسم النوع</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>

                        <div class="mb-3">
                            <label for="code" class="form-label">الكود</label>
                            <input type="text" class="form-control" id="code" name="code" required>
                            <small class="text-muted">استخدم كود فريد مثل window, door, etc.</small>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">المتغيرات الافتراضية</label>
                            <div class="border p-3 rounded" id="defaultVariablesContainer">
                                <div class="selected-variables mb-2">
                                    <!-- ستظهر المتغيرات المختارة هنا -->
                                </div>
                                <input type="hidden" id="default_variables" name="default_variables">
                            </div>
                            <small class="text-muted">اختر المتغيرات التي سيطلبها النظام لهذا النوع</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal تعديل نوع منتج -->
    <div class="modal fade" id="editProductTypeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تعديل نوع المنتج</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editProductTypeForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <input type="hidden" id="edit_id" name="id">

                        <div class="mb-3">
                            <label for="edit_name" class="form-label">اسم النوع</label>
                            <input type="text" class="form-control" id="edit_name" name="name" required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_code" class="form-label">الكود</label>
                            <input type="text" class="form-control" id="edit_code" name="code" required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">المتغيرات الافتراضية</label>
                            <div class="border p-3 rounded" id="editDefaultVariablesContainer">
                                <div class="selected-variables mb-2" id="editSelectedVariables">
                                    <!-- ستظهر المتغيرات المختارة هنا -->
                                </div>
                                <input type="hidden" id="edit_default_variables" name="default_variables">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let selectedVariables = [];
        let editSelectedVariables = [];

        // إضافة متغير إلى القائمة الافتراضية
        function addToDefaultVariables(variable) {
            if (!selectedVariables.includes(variable)) {
                selectedVariables.push(variable);
                updateSelectedVariablesDisplay();
            }
        }

        // إضافة متغير مخصص
        function addCustomVariable() {
            const customVar = $('#customVariable').val().trim();
            if (customVar && !selectedVariables.includes(customVar)) {
                selectedVariables.push(customVar);
                updateSelectedVariablesDisplay();
                $('#customVariable').val('');
            }
        }

        // تحديث عرض المتغيرات المختارة
        function updateSelectedVariablesDisplay() {
            const container = $('#defaultVariablesContainer .selected-variables');
            container.empty();

            selectedVariables.forEach((variable, index) => {
                const badge = `
            <span class="badge bg-primary me-1 mb-1">
                ${variable}
                <button type="button" class="btn-close btn-close-white ms-1" 
                        style="font-size: 0.5rem;" 
                        onclick="removeVariable(${index})"></button>
            </span>
        `;
                container.append(badge);
            });

            $('#default_variables').val(JSON.stringify(selectedVariables));
        }

        // حذف متغير
        function removeVariable(index) {
            selectedVariables.splice(index, 1);
            updateSelectedVariablesDisplay();
        }

        // فتح مودال التعديل
        $('#editProductTypeModal').on('show.bs.modal', function(event) {
            const button = $(event.relatedTarget);
            const productTypeId = button.data('id');

            $('#edit_id').val(productTypeId);
            $('#edit_name').val(button.data('name'));
            $('#edit_code').val(button.data('code'));
            $('#edit_description').val(button.data('description'));

            // تحميل المتغيرات الافتراضية
            const defaultVars = JSON.parse(button.data('default_variables') || '[]');
            editSelectedVariables = [...defaultVars];
            updateEditSelectedVariablesDisplay();

            $('#editProductTypeForm').attr('action', '/product-types/' + productTypeId);
        });

        // تحديث عرض المتغيرات المختارة في التعديل
        function updateEditSelectedVariablesDisplay() {
            const container = $('#editSelectedVariables');
            container.empty();

            editSelectedVariables.forEach((variable, index) => {
                const badge = `
            <span class="badge bg-primary me-1 mb-1">
                ${variable}
                <button type="button" class="btn-close btn-close-white ms-1" 
                        style="font-size: 0.5rem;" 
                        onclick="removeEditVariable(${index})"></button>
            </span>
        `;
                container.append(badge);
            });

            $('#edit_default_variables').val(JSON.stringify(editSelectedVariables));
        }

        // إضافة متغير في وضع التعديل
        function addToEditDefaultVariables(variable) {
            if (!editSelectedVariables.includes(variable)) {
                editSelectedVariables.push(variable);
                updateEditSelectedVariablesDisplay();
            }
        }

        // حذف متغير في وضع التعديل
        function removeEditVariable(index) {
            editSelectedVariables.splice(index, 1);
            updateEditSelectedVariablesDisplay();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\خالي رفيق\aluminum-factory\resources\views/product-types/index.blade.php ENDPATH**/ ?>