<!-- resources/views/calculations/index.blade.php -->


<?php $__env->startSection('title', 'الحسابات السابقة'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">الحسابات السابقة</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <?php if($calculations->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>العنوان</th>
                                            <th>نوع المنتج</th>
                                            <th>المتغيرات المدخلة</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $calculations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $calculation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($calculation->title); ?></td>
                                                <td>
                                                    <span class="badge bg-info"><?php echo e($calculation->productType->name); ?></span>
                                                </td>
                                                <td>
                                                    
                                                    <?php $__currentLoopData = $calculation->input_variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge bg-secondary me-1"><?php echo e($key); ?>:
                                                            <?php echo e($value); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td><?php echo e($calculation->created_at->format('Y-m-d H:i')); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('calculations.show', $calculation->id)); ?>"
                                                        class="btn btn-sm btn-info">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('calculations.destroy', $calculation->id)); ?>"
                                                        method="POST" class="d-inline"
                                                        onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php echo e($calculations->links()); ?>

                        <?php else: ?>
                            <div class="alert alert-info">
                                لا توجد حسابات سابقة.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\خالي رفيق\aluminum-factory\resources\views/calculations/index.blade.php ENDPATH**/ ?>